<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Application;
use App\Models\Document;
use Illuminate\Support\Facades\Auth;

class ApplicationController extends Controller
{
    public function create() {
        return view('application.create');
    }

    public function store(Request $request) {
        $data = $request->validate([
            'full_name' => 'required|string|max:255',
            'date_of_birth' => 'required|date',
            'gender' => 'required|string',
            'nationality' => 'required|string',
            'phone' => 'required|string',
            'email' => 'required|email',
            'cv' => 'required|file|mimes:pdf|max:2048',
        ]);

        $application = Application::create([
            'user_id' => Auth::id(),
            'full_name' => $data['full_name'],
            'date_of_birth' => $data['date_of_birth'],
            'gender' => $data['gender'],
            'nationality' => $data['nationality'],
            'phone' => $data['phone'],
            'email' => $data['email'],
            'preferred_contact' => 'email',
            'personal_statement' => '',
            'weekly_availability' => 0,
        ]);

        // Store file
        $path = $request->file('cv')->store("documents", "public");

        Document::create([
            'application_id' => $application->id,
            'type' => 'cv',
            'file_path' => $path,
        ]);

        return redirect('/')->with('success', 'Application submitted!');
    }

    public function index() {
        $applications = Application::with('documents')->get();
        return view('admin.index', compact('applications'));
    }

    public function show($id) {
        $application = Application::with('documents')->findOrFail($id);
        return view('admin.show', compact('application'));
    }
}
